import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the grid size
rows, cols = 6, 4
fig, ax = plt.subplots(figsize=(6, 9))

# Define colors for the pieces
colors = {
    "rightl0": "blue",
    "rightl1": "green",
    "square0": "red",
    "square1": "yellow",
    "clear": "white"
}

# Add grid lines
for row in range(rows):
    for col in range(cols):
        ax.add_patch(patches.Rectangle((col, rows - 1 - row), 1, 1, fill=True, edgecolor='black', facecolor=colors["clear"]))

# Define positions for pieces
pieces = {
    "rightl0": [(0, 3), (1, 3), (0, 2)],
    "rightl1": [(0, 1), (1, 1), (0, 0)],
    "square0": [(2, 1)],
    "square1": [(2, 2)]
}

# Draw the pieces
for piece, positions in pieces.items():
    for pos in positions:
        facecolor = colors[piece]
        edgecolor = 'black'
        linewidth = 3 if piece.startswith("rightl") else 2
        ax.add_patch(patches.Rectangle((pos[0], rows - 1 - pos[1]), 1, 1, fill=True, edgecolor=edgecolor, linewidth=linewidth, facecolor=facecolor))
        ax.text(pos[0] + 0.5, rows - 1 - pos[1] + 0.7, piece, ha='center', va='center', fontsize=8, color='black')
        ax.text(pos[0] + 0.5, rows - 1 - pos[1] + 0.3, "occupied", ha='center', va='center', fontsize=6, color='black')

# Add text for clear positions
clear_positions = [
    (0, 5), (1, 5), (2, 5), (3, 5),
    (0, 4), (1, 4), (2, 4), (3, 4),
    (2, 3), (3, 3),
    (1, 2), (3, 2),
    (3, 1),
    (1, 0), (2, 0), (3, 0)
]

for pos in clear_positions:
    ax.text(pos[0] + 0.5, rows - 1 - pos[1] + 0.5, f"f{pos[1]}-{pos[0]}f", ha='center', va='center', fontsize=8, color='black')
    ax.text(pos[0] + 0.5, rows - 1 - pos[1] + 0.2, "clear", ha='center', va='center', fontsize=6, color='black')

# Add legend
legend_elements = [patches.Patch(facecolor=colors["rightl0"], edgecolor='black', label='rightl0 (occupied)'),
                   patches.Patch(facecolor=colors["rightl1"], edgecolor='black', label='rightl1 (occupied)'),
                   patches.Patch(facecolor=colors["square0"], edgecolor='black', label='square0 (occupied)'),
                   patches.Patch(facecolor=colors["square1"], edgecolor='black', label='square1 (occupied)'),
                   patches.Patch(facecolor=colors["clear"], edgecolor='black', label='clear')]

ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Set limits and aspect
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_21.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# The text labels for positions and statuses are not clearly visible or readable due to low contrast and overlap. The legend overlaps with the grid, affecting clarity.
